<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTubeAnalytics;

class Errors extends \Google\Collection
{
  public const CODE_BAD_REQUEST = 'BAD_REQUEST';
  public const CODE_FORBIDDEN = 'FORBIDDEN';
  public const CODE_NOT_FOUND = 'NOT_FOUND';
  public const CODE_CONFLICT = 'CONFLICT';
  public const CODE_GONE = 'GONE';
  public const CODE_PRECONDITION_FAILED = 'PRECONDITION_FAILED';
  public const CODE_INTERNAL_ERROR = 'INTERNAL_ERROR';
  public const CODE_SERVICE_UNAVAILABLE = 'SERVICE_UNAVAILABLE';
  protected $collection_key = 'error';
  /**
   * Global error code. Deprecated and ignored. Set custom error codes in
   * ErrorProto.domain and ErrorProto.code instead.
   *
   * @deprecated
   * @var string
   */
  public $code;
  protected $errorType = ErrorProto::class;
  protected $errorDataType = 'array';
  /**
   * Request identifier generated by the service, which can be used to identify
   * the error in the logs
   *
   * @var string
   */
  public $requestId;

  /**
   * Global error code. Deprecated and ignored. Set custom error codes in
   * ErrorProto.domain and ErrorProto.code instead.
   *
   * Accepted values: BAD_REQUEST, FORBIDDEN, NOT_FOUND, CONFLICT, GONE,
   * PRECONDITION_FAILED, INTERNAL_ERROR, SERVICE_UNAVAILABLE
   *
   * @deprecated
   * @param self::CODE_* $code
   */
  public function setCode($code)
  {
    $this->code = $code;
  }
  /**
   * @deprecated
   * @return self::CODE_*
   */
  public function getCode()
  {
    return $this->code;
  }
  /**
   * Specific error description and codes
   *
   * @param ErrorProto[] $error
   */
  public function setError($error)
  {
    $this->error = $error;
  }
  /**
   * @return ErrorProto[]
   */
  public function getError()
  {
    return $this->error;
  }
  /**
   * Request identifier generated by the service, which can be used to identify
   * the error in the logs
   *
   * @param string $requestId
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
  }
  /**
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Errors::class, 'Google_Service_YouTubeAnalytics_Errors');
