<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Slides;

class UpdateTableColumnPropertiesRequest extends \Google\Collection
{
  protected $collection_key = 'columnIndices';
  /**
   * The list of zero-based indices specifying which columns to update. If no
   * indices are provided, all columns in the table will be updated.
   *
   * @var int[]
   */
  public $columnIndices;
  /**
   * The fields that should be updated. At least one field must be specified.
   * The root `tableColumnProperties` is implied and should not be specified. A
   * single `"*"` can be used as short-hand for listing every field. For example
   * to update the column width, set `fields` to `"column_width"`. If
   * '"column_width"' is included in the field mask but the property is left
   * unset, the column width will default to 406,400 EMU (32 points).
   *
   * @var string
   */
  public $fields;
  /**
   * The object ID of the table.
   *
   * @var string
   */
  public $objectId;
  protected $tableColumnPropertiesType = TableColumnProperties::class;
  protected $tableColumnPropertiesDataType = '';

  /**
   * The list of zero-based indices specifying which columns to update. If no
   * indices are provided, all columns in the table will be updated.
   *
   * @param int[] $columnIndices
   */
  public function setColumnIndices($columnIndices)
  {
    $this->columnIndices = $columnIndices;
  }
  /**
   * @return int[]
   */
  public function getColumnIndices()
  {
    return $this->columnIndices;
  }
  /**
   * The fields that should be updated. At least one field must be specified.
   * The root `tableColumnProperties` is implied and should not be specified. A
   * single `"*"` can be used as short-hand for listing every field. For example
   * to update the column width, set `fields` to `"column_width"`. If
   * '"column_width"' is included in the field mask but the property is left
   * unset, the column width will default to 406,400 EMU (32 points).
   *
   * @param string $fields
   */
  public function setFields($fields)
  {
    $this->fields = $fields;
  }
  /**
   * @return string
   */
  public function getFields()
  {
    return $this->fields;
  }
  /**
   * The object ID of the table.
   *
   * @param string $objectId
   */
  public function setObjectId($objectId)
  {
    $this->objectId = $objectId;
  }
  /**
   * @return string
   */
  public function getObjectId()
  {
    return $this->objectId;
  }
  /**
   * The table column properties to update. If the value of
   * `table_column_properties#column_width` in the request is less than 406,400
   * EMU (32 points), a 400 bad request error is returned.
   *
   * @param TableColumnProperties $tableColumnProperties
   */
  public function setTableColumnProperties(TableColumnProperties $tableColumnProperties)
  {
    $this->tableColumnProperties = $tableColumnProperties;
  }
  /**
   * @return TableColumnProperties
   */
  public function getTableColumnProperties()
  {
    return $this->tableColumnProperties;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UpdateTableColumnPropertiesRequest::class, 'Google_Service_Slides_UpdateTableColumnPropertiesRequest');
