<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecureSourceManager\Resource;

use Google\Service\SecureSourceManager\IssueComment;
use Google\Service\SecureSourceManager\ListIssueCommentsResponse;
use Google\Service\SecureSourceManager\Operation;

/**
 * The "issueComments" collection of methods.
 * Typical usage is:
 *  <code>
 *   $securesourcemanagerService = new Google\Service\SecureSourceManager(...);
 *   $issueComments = $securesourcemanagerService->projects_locations_repositories_issues_issueComments;
 *  </code>
 */
class ProjectsLocationsRepositoriesIssuesIssueComments extends \Google\Service\Resource
{
  /**
   * Creates an issue comment. (issueComments.create)
   *
   * @param string $parent Required. The issue in which to create the issue
   * comment. Format: `projects/{project_number}/locations/{location_id}/repositor
   * ies/{repository_id}/issues/{issue_id}`
   * @param IssueComment $postBody
   * @param array $optParams Optional parameters.
   * @return Operation
   * @throws \Google\Service\Exception
   */
  public function create($parent, IssueComment $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], Operation::class);
  }
  /**
   * Deletes an issue comment. (issueComments.delete)
   *
   * @param string $name Required. Name of the issue comment to delete. The format
   * is `projects/{project_number}/locations/{location_id}/repositories/{repositor
   * y_id}/issues/{issue_id}/issueComments/{comment_id}`.
   * @param array $optParams Optional parameters.
   * @return Operation
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], Operation::class);
  }
  /**
   * Gets an issue comment. (issueComments.get)
   *
   * @param string $name Required. Name of the issue comment to retrieve. The
   * format is `projects/{project}/locations/{location}/repositories/{repository}/
   * issues/{issue_id}/issueComments/{comment_id}`.
   * @param array $optParams Optional parameters.
   * @return IssueComment
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], IssueComment::class);
  }
  /**
   * Lists comments in an issue.
   * (issueComments.listProjectsLocationsRepositoriesIssuesIssueComments)
   *
   * @param string $parent Required. The issue in which to list the comments.
   * Format: `projects/{project_number}/locations/{location_id}/repositories/{repo
   * sitory_id}/issues/{issue_id}`
   * @param array $optParams Optional parameters.
   *
   * @opt_param int pageSize Optional. Requested page size. Server may return
   * fewer items than requested. If unspecified, server will pick an appropriate
   * default.
   * @opt_param string pageToken Optional. A token identifying a page of results
   * the server should return.
   * @return ListIssueCommentsResponse
   * @throws \Google\Service\Exception
   */
  public function listProjectsLocationsRepositoriesIssuesIssueComments($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], ListIssueCommentsResponse::class);
  }
  /**
   * Updates an issue comment. (issueComments.patch)
   *
   * @param string $name Identifier. Unique identifier for an issue comment. The
   * comment id is generated by the server. Format: `projects/{project}/locations/
   * {location}/repositories/{repository}/issues/{issue}/issueComments/{comment_id
   * }`
   * @param IssueComment $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string updateMask Optional. Field mask is used to specify the
   * fields to be overwritten in the issue comment resource by the update. The
   * fields specified in the update_mask are relative to the resource, not the
   * full request. A field will be overwritten if it is in the mask. The special
   * value "*" means full replacement.
   * @return Operation
   * @throws \Google\Service\Exception
   */
  public function patch($name, IssueComment $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('patch', [$params], Operation::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsRepositoriesIssuesIssueComments::class, 'Google_Service_SecureSourceManager_Resource_ProjectsLocationsRepositoriesIssuesIssueComments');
