<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataflow;

class CounterUpdate extends \Google\Model
{
  /**
   * Boolean value for And, Or.
   *
   * @var bool
   */
  public $boolean;
  protected $boundedTrieType = BoundedTrie::class;
  protected $boundedTrieDataType = '';
  /**
   * True if this counter is reported as the total cumulative aggregate value
   * accumulated since the worker started working on this WorkItem. By default
   * this is false, indicating that this counter is reported as a delta.
   *
   * @var bool
   */
  public $cumulative;
  protected $distributionType = DistributionUpdate::class;
  protected $distributionDataType = '';
  /**
   * Floating point value for Sum, Max, Min.
   *
   * @var 
   */
  public $floatingPoint;
  protected $floatingPointListType = FloatingPointList::class;
  protected $floatingPointListDataType = '';
  protected $floatingPointMeanType = FloatingPointMean::class;
  protected $floatingPointMeanDataType = '';
  protected $integerType = SplitInt64::class;
  protected $integerDataType = '';
  protected $integerGaugeType = IntegerGauge::class;
  protected $integerGaugeDataType = '';
  protected $integerListType = IntegerList::class;
  protected $integerListDataType = '';
  protected $integerMeanType = IntegerMean::class;
  protected $integerMeanDataType = '';
  /**
   * Value for internally-defined counters used by the Dataflow service.
   *
   * @var array
   */
  public $internal;
  protected $nameAndKindType = NameAndKind::class;
  protected $nameAndKindDataType = '';
  /**
   * The service-generated short identifier for this counter. The short_id ->
   * (name, metadata) mapping is constant for the lifetime of a job.
   *
   * @var string
   */
  public $shortId;
  protected $stringListType = StringList::class;
  protected $stringListDataType = '';
  protected $structuredNameAndMetadataType = CounterStructuredNameAndMetadata::class;
  protected $structuredNameAndMetadataDataType = '';

  /**
   * Boolean value for And, Or.
   *
   * @param bool $boolean
   */
  public function setBoolean($boolean)
  {
    $this->boolean = $boolean;
  }
  /**
   * @return bool
   */
  public function getBoolean()
  {
    return $this->boolean;
  }
  /**
   * Bounded trie data
   *
   * @param BoundedTrie $boundedTrie
   */
  public function setBoundedTrie(BoundedTrie $boundedTrie)
  {
    $this->boundedTrie = $boundedTrie;
  }
  /**
   * @return BoundedTrie
   */
  public function getBoundedTrie()
  {
    return $this->boundedTrie;
  }
  /**
   * True if this counter is reported as the total cumulative aggregate value
   * accumulated since the worker started working on this WorkItem. By default
   * this is false, indicating that this counter is reported as a delta.
   *
   * @param bool $cumulative
   */
  public function setCumulative($cumulative)
  {
    $this->cumulative = $cumulative;
  }
  /**
   * @return bool
   */
  public function getCumulative()
  {
    return $this->cumulative;
  }
  /**
   * Distribution data
   *
   * @param DistributionUpdate $distribution
   */
  public function setDistribution(DistributionUpdate $distribution)
  {
    $this->distribution = $distribution;
  }
  /**
   * @return DistributionUpdate
   */
  public function getDistribution()
  {
    return $this->distribution;
  }
  public function setFloatingPoint($floatingPoint)
  {
    $this->floatingPoint = $floatingPoint;
  }
  public function getFloatingPoint()
  {
    return $this->floatingPoint;
  }
  /**
   * List of floating point numbers, for Set.
   *
   * @param FloatingPointList $floatingPointList
   */
  public function setFloatingPointList(FloatingPointList $floatingPointList)
  {
    $this->floatingPointList = $floatingPointList;
  }
  /**
   * @return FloatingPointList
   */
  public function getFloatingPointList()
  {
    return $this->floatingPointList;
  }
  /**
   * Floating point mean aggregation value for Mean.
   *
   * @param FloatingPointMean $floatingPointMean
   */
  public function setFloatingPointMean(FloatingPointMean $floatingPointMean)
  {
    $this->floatingPointMean = $floatingPointMean;
  }
  /**
   * @return FloatingPointMean
   */
  public function getFloatingPointMean()
  {
    return $this->floatingPointMean;
  }
  /**
   * Integer value for Sum, Max, Min.
   *
   * @param SplitInt64 $integer
   */
  public function setInteger(SplitInt64 $integer)
  {
    $this->integer = $integer;
  }
  /**
   * @return SplitInt64
   */
  public function getInteger()
  {
    return $this->integer;
  }
  /**
   * Gauge data
   *
   * @param IntegerGauge $integerGauge
   */
  public function setIntegerGauge(IntegerGauge $integerGauge)
  {
    $this->integerGauge = $integerGauge;
  }
  /**
   * @return IntegerGauge
   */
  public function getIntegerGauge()
  {
    return $this->integerGauge;
  }
  /**
   * List of integers, for Set.
   *
   * @param IntegerList $integerList
   */
  public function setIntegerList(IntegerList $integerList)
  {
    $this->integerList = $integerList;
  }
  /**
   * @return IntegerList
   */
  public function getIntegerList()
  {
    return $this->integerList;
  }
  /**
   * Integer mean aggregation value for Mean.
   *
   * @param IntegerMean $integerMean
   */
  public function setIntegerMean(IntegerMean $integerMean)
  {
    $this->integerMean = $integerMean;
  }
  /**
   * @return IntegerMean
   */
  public function getIntegerMean()
  {
    return $this->integerMean;
  }
  /**
   * Value for internally-defined counters used by the Dataflow service.
   *
   * @param array $internal
   */
  public function setInternal($internal)
  {
    $this->internal = $internal;
  }
  /**
   * @return array
   */
  public function getInternal()
  {
    return $this->internal;
  }
  /**
   * Counter name and aggregation type.
   *
   * @param NameAndKind $nameAndKind
   */
  public function setNameAndKind(NameAndKind $nameAndKind)
  {
    $this->nameAndKind = $nameAndKind;
  }
  /**
   * @return NameAndKind
   */
  public function getNameAndKind()
  {
    return $this->nameAndKind;
  }
  /**
   * The service-generated short identifier for this counter. The short_id ->
   * (name, metadata) mapping is constant for the lifetime of a job.
   *
   * @param string $shortId
   */
  public function setShortId($shortId)
  {
    $this->shortId = $shortId;
  }
  /**
   * @return string
   */
  public function getShortId()
  {
    return $this->shortId;
  }
  /**
   * List of strings, for Set.
   *
   * @param StringList $stringList
   */
  public function setStringList(StringList $stringList)
  {
    $this->stringList = $stringList;
  }
  /**
   * @return StringList
   */
  public function getStringList()
  {
    return $this->stringList;
  }
  /**
   * Counter structured name and metadata.
   *
   * @param CounterStructuredNameAndMetadata $structuredNameAndMetadata
   */
  public function setStructuredNameAndMetadata(CounterStructuredNameAndMetadata $structuredNameAndMetadata)
  {
    $this->structuredNameAndMetadata = $structuredNameAndMetadata;
  }
  /**
   * @return CounterStructuredNameAndMetadata
   */
  public function getStructuredNameAndMetadata()
  {
    return $this->structuredNameAndMetadata;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CounterUpdate::class, 'Google_Service_Dataflow_CounterUpdate');
