<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudVideoIntelligence;

class GoogleCloudVideointelligenceV1FaceFrame extends \Google\Collection
{
  protected $collection_key = 'normalizedBoundingBoxes';
  protected $normalizedBoundingBoxesType = GoogleCloudVideointelligenceV1NormalizedBoundingBox::class;
  protected $normalizedBoundingBoxesDataType = 'array';
  /**
   * Time-offset, relative to the beginning of the video, corresponding to the
   * video frame for this location.
   *
   * @var string
   */
  public $timeOffset;

  /**
   * Normalized Bounding boxes in a frame. There can be more than one boxes if
   * the same face is detected in multiple locations within the current frame.
   *
   * @param GoogleCloudVideointelligenceV1NormalizedBoundingBox[] $normalizedBoundingBoxes
   */
  public function setNormalizedBoundingBoxes($normalizedBoundingBoxes)
  {
    $this->normalizedBoundingBoxes = $normalizedBoundingBoxes;
  }
  /**
   * @return GoogleCloudVideointelligenceV1NormalizedBoundingBox[]
   */
  public function getNormalizedBoundingBoxes()
  {
    return $this->normalizedBoundingBoxes;
  }
  /**
   * Time-offset, relative to the beginning of the video, corresponding to the
   * video frame for this location.
   *
   * @param string $timeOffset
   */
  public function setTimeOffset($timeOffset)
  {
    $this->timeOffset = $timeOffset;
  }
  /**
   * @return string
   */
  public function getTimeOffset()
  {
    return $this->timeOffset;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudVideointelligenceV1FaceFrame::class, 'Google_Service_CloudVideoIntelligence_GoogleCloudVideointelligenceV1FaceFrame');
