<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class LinkedEntity extends \Google\Model
{
  /**
   * entity_id is a concept unique identifier. These are prefixed by a string
   * that identifies the entity coding system, followed by the unique identifier
   * within that system. For example, "UMLS/C0000970". This also supports ad hoc
   * entities, which are formed by normalizing entity mention content.
   *
   * @var string
   */
  public $entityId;

  /**
   * entity_id is a concept unique identifier. These are prefixed by a string
   * that identifies the entity coding system, followed by the unique identifier
   * within that system. For example, "UMLS/C0000970". This also supports ad hoc
   * entities, which are formed by normalizing entity mention content.
   *
   * @param string $entityId
   */
  public function setEntityId($entityId)
  {
    $this->entityId = $entityId;
  }
  /**
   * @return string
   */
  public function getEntityId()
  {
    return $this->entityId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LinkedEntity::class, 'Google_Service_CloudHealthcare_LinkedEntity');
